#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Netwton's FractalMod01.fsh  by   ThePersonOfStuff  
//https://www.shadertoy.com/view/mdGyRR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 p1;
vec2 p2;
vec2 p3;
vec2 p4;
const float PI = 3.14159265358979323846264338;

vec2 mult(vec2 i1, vec2 i2) {
    return vec2(i1.x*i2.x-i1.y*i2.y, i1.x*i2.y+i1.y*i2.x);
}

vec2 div(vec2 i1, vec2 i2) {
    float ac = i1.x * i2.x;
    float bd = i1.y * i2.y;
    float bc = i1.y * i2.x;
    float ad = i1.x * i2.y;
    
    float denom = i2.x*i2.x + i2.y * i2.y;
    
    return vec2(ac + bd, bc - ad)/denom;
    
}

vec2 eval(vec2 p) {
    return mult(mult(p - p1, p - p2), mult(p - p3, p - p4));
}

vec2 evalPrime(vec2 p) {
    //derivative of p^4+(p1+p2+p3+p4)p^3+(p1p2+p1p3+p1p4+p2p3+p2p4+p3p4)p^2+(p1p2p3+p1p2p4+p1p3p4+p2p3p4)p+p1p2p3p4
    // is equal to 4p^3+3(p1+p2+p3+p4)p^2+2(p1(p2+p3+p4)+p2(p3+p4)+p3p4)p+(p1(p2(p3+p4)+p3p4)+p2p3p4)
    vec2 comp1 =  4.0 * mult(mult(p, p), p); //4p^3
    vec2 comp2 = 3.0 * mult(mult(p, p), p1+p2+p3+p4);//3p^2(p1+p2+p3+p4)
    vec2 comp3 = 2.0 * mult(p, mult(p1, p2+p3+p4) + mult(p2, p3+p4) + mult(p3, p4)); //2p(p1p2+p1p3+p1p4+p2p3+p2p4+p3p4)
    vec2 comp4 = mult(p1, mult(p2, p3+p4) + mult(p3, p4)) + mult(p2, mult(p3, p4)); //p1(p2(p3+p4)+p3p4)+p2p3p4
    return comp1 - comp2 + comp3 - comp4;
}

vec2 netwonify(vec2 p) {
    return p  - div(eval(p), evalPrime(p));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uv = fragCoord / iResolution.xy - 0.5;
    uv.x *= iResolution.x/iResolution.y;
    uv *= 2.0;
    
    p1 = vec2(sin(iTime), cos(iTime));
    p2 = vec2(sin(iTime + 2.0*PI/3.0), cos(iTime+ 2.0*PI/3.0));
    p3 = vec2(sin(iTime - 2.0*PI/3.0), cos(iTime - 2.0*PI/3.0));
    p4 = p1+p2+p3+vec2(sin(iTime/1.61/1.61/1.61), cos(iTime / 1.61 /1.61 / 1.61 / 1.61));
    
    
    p1 *= sin(iTime/1.61);
    p2 *= vec2(cos(iTime/1.61/1.61), sin(iTime/1.61/1.61));
    p3 += sin(iTime*1.61);
    p4 *= sin(iTime);
    
    p1 *= 1.0;
    p2 *= 1.0;
    p3 *= 0.5 + 0.25 * sin(iTime*1.61*1.61);
    
    
    
    if(length(uv-p1) < 0.01 || length(uv-p2) < 0.01 || length(uv-p3) < 0.01 || length(uv-p4) < 0.01) {
        fragColor = vec4(1.0, 1.0, 1.0, 1.0);
       // return;
    }
    
    const int iters = 19;
    float totIters = 0.0;
    for(int i = 0; i < iters; i++) {
        uv = netwonify(uv);
        totIters += 1.0;
        if(length(uv - p1) < 0.0001) {
            break;
        }
        if(length(uv - p2) < 0.0001) {
            break;
        }
        if(length(uv - p3) < 0.0001) {
            break;
        }
        if(length(uv - p4) < 0.0001) {
            break;
        }
    }
    
    float distp1 = max(0.0, 1.0-length(uv - p1) * 1000.0);
    float distp2 = max(0.0, 1.0-length(uv - p2) * 1000.0);
    float distp3 = max(0.0, 1.0-length(uv - p3) * 1000.0);
    float distp4 = max(0.0, 1.0-length(uv - p4) * 1000.0);
    
    const vec3 col1 = vec3(1.0, 0.0, 0.0);
    const vec3 col2 = vec3(0.0, 1.0, 0.0);
    const vec3 col3 = vec3(0.0, 0.0, 1.0);
    const vec3 col4 = vec3(1.0, 1.0, 0.0);
    
    vec3 col = col1 * distp1 + col2 * distp2 + col3 * distp3 + col4 * distp4;
    
    
    col *= 1.0-(totIters/float(iters));
    
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

